/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.doris;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.doris.client.DorisResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceDoris
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceDoris.class);

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerServiceDoris.validateConfig(): Service: " + serviceName);
        }
        if (this.configs != null) {
            try {
                if (!this.configs.containsKey("password")) {
                    this.configs.put("password", null);
                }
                ret = DorisResourceManager.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException he) {
                LOG.error("<== RangerServiceDoris.validateConfig() Error:" + (Object)((Object)he));
                throw he;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerServiceDoris.validateConfig(): Response: " + ret);
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceDoris.lookupResource() Context: (" + context + ")");
        }
        if (context != null) {
            try {
                if (!configs.containsKey("password")) {
                    configs.put("password", null);
                }
                ret = DorisResourceManager.getDorisResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceDoris.lookupResource() Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceDoris.lookupResource() Response: (" + ret + ")");
        }
        return ret;
    }
}

