/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.doris.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.doris.client.DorisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(DorisConnectionManager.class);
    protected ConcurrentMap<String, DorisClient> dorisConnectionCache = new ConcurrentHashMap<String, DorisClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public DorisClient getDorisConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        DorisClient dorisClient = null;
        if (serviceType != null) {
            dorisClient = (DorisClient)this.dorisConnectionCache.get(serviceName);
            if (dorisClient == null) {
                if (configs != null) {
                    Callable<DorisClient> connectDoris = new Callable<DorisClient>(){

                        @Override
                        public DorisClient call() throws Exception {
                            return new DorisClient(serviceName, configs);
                        }
                    };
                    try {
                        dorisClient = (DorisClient)TimedEventUtil.timedTask((Callable)connectDoris, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting to Doris cluster: " + serviceName + " using config: " + configs, (Throwable)e);
                    }
                    DorisClient oldClient = null;
                    oldClient = dorisClient != null ? this.dorisConnectionCache.putIfAbsent(serviceName, dorisClient) : (DorisClient)this.dorisConnectionCache.get(serviceName);
                    if (oldClient != null) {
                        if (dorisClient != null) {
                            dorisClient.close();
                        }
                        dorisClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error("Connection Config not defined for asset :" + serviceName, new Throwable());
                }
            } else {
                try {
                    dorisClient.getCatalogList("*", null);
                }
                catch (Exception e) {
                    this.dorisConnectionCache.remove(serviceName);
                    dorisClient.close();
                    dorisClient = this.getDorisConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error("Asset not found with name " + serviceName, new Throwable());
        }
        return dorisClient;
    }
}

