/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.doris.client;

import java.io.Closeable;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisClient
extends BaseClient
implements Closeable {
    public static final String USER_NAME_PROP = "user";
    public static final String PASSWORD_PROP = "password";
    private static final Logger LOG = LoggerFactory.getLogger(DorisClient.class);
    private static final String ERR_MSG = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private Connection con;

    public DorisClient(String serviceName) throws Exception {
        super(serviceName, null);
        this.init();
    }

    public DorisClient(String serviceName, Map<String, String> properties) throws Exception {
        super(serviceName, properties);
        this.init();
    }

    private void init() throws Exception {
        Subject.doAs(this.getLoginSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DorisClient.this.initConnection();
                return null;
            }
        });
    }

    private void initConnection() {
        Properties prop = this.getConfigHolder().getRangerSection();
        String driverClassName = prop.getProperty("jdbc.driver_class");
        String url = prop.getProperty("jdbc.url");
        Properties properties = new Properties();
        properties.put(USER_NAME_PROP, prop.getProperty("username"));
        if (prop.getProperty(PASSWORD_PROP) != null) {
            properties.put(PASSWORD_PROP, prop.getProperty(PASSWORD_PROP));
        }
        if (driverClassName != null) {
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
            }
            catch (SQLException e) {
                String msgDesc = "initConnection: Caught SQLException while registering the Doris driver.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (IllegalAccessException ilae) {
                String msgDesc = "initConnection: Class or its nullary constructor might not accessible.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ilae);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)ilae), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (InstantiationException ie) {
                String msgDesc = "initConnection: Class may not have its nullary constructor or may be the instantiation fails for some other reason.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ie);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)ie), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (ExceptionInInitializerError eie) {
                String msgDesc = "initConnection: Got ExceptionInInitializerError, The initialization provoked by this method fails.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)eie);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)eie), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (SecurityException se) {
                String msgDesc = "initConnection: unable to initiate connection to Doris instance, The caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of s.checkPackageAccess() denies access to the package of this class.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (Throwable t) {
                String msgDesc = "initConnection: Unable to connect to Doris instance, please provide valid value of field : {jdbc.driverClassName}.";
                HadoopException hdpException = new HadoopException(msgDesc, t);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
        }
        try {
            this.con = DriverManager.getConnection(url, properties);
        }
        catch (SQLException e) {
            String msgDesc = "Unable to connect to Doris instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
        catch (SecurityException se) {
            String msgDesc = "Unable to connect to Doris instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
        catch (Throwable t) {
            String msgDesc = "initConnection: Unable to connect to Doris instance, ";
            HadoopException hdpException = new HadoopException(msgDesc, t);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
    }

    /*
     * Loose catch block
     */
    private List<String> getCatalogs(String needle, List<String> catalogs) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con != null) {
            Statement stat = null;
            ResultSet rs = null;
            String sql = "SHOW CATALOGS";
            try {
                if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                    sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                }
                stat = this.con.createStatement();
                rs = stat.executeQuery(sql);
                while (rs.next()) {
                    String catalogName = rs.getString(2);
                    if (catalogs != null && catalogs.contains(catalogName)) continue;
                    ret.add(catalogName);
                }
                this.close(rs);
                this.close(stat);
            }
            catch (SQLTimeoutException sqlt) {
                String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                this.close(rs);
                this.close(stat);
            }
            catch (SQLException se) {
                String msg = "Unable to execute SQL [" + sql + "]. ";
                HadoopException he = new HadoopException(msg, (Throwable)se);
                he.generateResponseDataMap(false, DorisClient.getMessage((Throwable)se), msg + ERR_MSG, null, null);
                throw he;
                {
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        throw throwable;
                    }
                }
            }
        }
        return ret;
    }

    public List<String> getCatalogList(String needle, List<String> catalogs) throws HadoopException {
        final String ndl = needle;
        final List<String> catList = catalogs;
        List<String> ctls = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = DorisClient.this.getCatalogs(ndl, catList);
                }
                catch (HadoopException he) {
                    LOG.error("<== DorisClient.getCatalogList() :Unable to get the Catalog List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return ctls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getSchemas(String needle, List<String> catalogs, List<String> schemas) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = null;
        try {
            if (catalogs == null || catalogs.isEmpty()) return ret;
            for (String catalog : catalogs) {
                sql = "SHOW SCHEMAS FROM `" + StringEscapeUtils.escapeSql((String)catalog) + "`";
                try {
                    if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                        sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                    }
                    stat = this.con.createStatement();
                    rs = stat.executeQuery(sql);
                    while (rs.next()) {
                        String schema = rs.getString(1);
                        if (schemas != null && schemas.contains(schema)) continue;
                        ret.add(schema);
                    }
                    this.close(rs);
                    this.close(stat);
                    rs = null;
                    stat = null;
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.close(stat);
                    rs = null;
                    stat = null;
                    throw throwable;
                    return ret;
                }
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== DorisClient.getSchemas() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== DorisClient.getSchemas() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    public List<String> getSchemaList(String needle, List<String> catalogs, List<String> schemas) throws HadoopException {
        final String ndl = needle;
        final List<String> cats = catalogs;
        final List<String> shms = schemas;
        List<String> schemaList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = DorisClient.this.getSchemas(ndl, cats, shms);
                }
                catch (HadoopException he) {
                    LOG.error("<== DorisClient.getSchemaList() :Unable to get the Schema List", (Throwable)he);
                }
                return ret;
            }
        });
        return schemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getTables(String needle, List<String> catalogs, List<String> schemas, List<String> tables) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = null;
        if (catalogs == null) return ret;
        if (catalogs.isEmpty() || schemas == null || schemas.isEmpty()) return ret;
        try {
            for (String catalog : catalogs) {
                for (String schema : schemas) {
                    sql = "SHOW tables FROM `" + StringEscapeUtils.escapeSql((String)catalog) + "`.`" + StringEscapeUtils.escapeSql((String)schema) + "`";
                    try {
                        if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                            sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                        }
                        stat = this.con.createStatement();
                        rs = stat.executeQuery(sql);
                        while (rs.next()) {
                            String table = rs.getString(1);
                            if (tables != null && tables.contains(table)) continue;
                            ret.add(table);
                        }
                        this.close(rs);
                        this.close(stat);
                        rs = null;
                        stat = null;
                    }
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        rs = null;
                        stat = null;
                        throw throwable;
                    }
                }
                continue;
                return ret;
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== DorisClient.getTables() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== DorisClient.getTables() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    public List<String> getTableList(String needle, List<String> catalogs, List<String> schemas, List<String> tables) throws HadoopException {
        final String ndl = needle;
        final List<String> cats = catalogs;
        final List<String> shms = schemas;
        final List<String> tbls = tables;
        List<String> tableList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = DorisClient.this.getTables(ndl, cats, shms, tbls);
                }
                catch (HadoopException he) {
                    LOG.error("<== DorisClient.getTableList() :Unable to get the Column List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getColumns(String needle, List<String> catalogs, List<String> schemas, List<String> tables, List<String> columns) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        String regex = null;
        ResultSet rs = null;
        String sql = null;
        Statement stat = null;
        if (needle != null && !needle.isEmpty()) {
            regex = needle;
        }
        if (catalogs == null || catalogs.isEmpty() || schemas == null || schemas.isEmpty() || tables == null || tables.isEmpty()) return ret;
        try {
            for (String catalog : catalogs) {
                for (String schema : schemas) {
                    for (String table : tables) {
                        sql = "SHOW COLUMNS FROM `" + StringEscapeUtils.escapeSql((String)catalog) + "`.`" + StringEscapeUtils.escapeSql((String)schema) + "`.`" + StringEscapeUtils.escapeSql((String)table) + "`";
                        try {
                            stat = this.con.createStatement();
                            rs = stat.executeQuery(sql);
                            while (rs.next()) {
                                String column = rs.getString(1);
                                if (columns != null && columns.contains(column)) continue;
                                if (regex == null) {
                                    ret.add(column);
                                    continue;
                                }
                                if (!FilenameUtils.wildcardMatch((String)column, (String)regex)) continue;
                                ret.add(column);
                            }
                            this.close(rs);
                            this.close(stat);
                            stat = null;
                            rs = null;
                        }
                        catch (Throwable throwable) {
                            this.close(rs);
                            this.close(stat);
                            stat = null;
                            rs = null;
                            throw throwable;
                        }
                    }
                }
                continue;
                return ret;
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== DorisClient.getColumns() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== DorisClient.getColumns() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    public List<String> getColumnList(String needle, List<String> catalogs, List<String> schemas, List<String> tables, List<String> columns) throws HadoopException {
        final String ndl = needle;
        final List<String> cats = catalogs;
        final List<String> shms = schemas;
        final List<String> tbls = tables;
        final List<String> cols = columns;
        List<String> columnList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = DorisClient.this.getColumns(ndl, cats, shms, tbls, cols);
                }
                catch (HadoopException he) {
                    LOG.error("<== DorisClient.getColumnList() :Unable to get the Column List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return columnList;
    }

    public List<String> getResourceList(String needle, List<String> finalResourceList) {
        final String ndl = needle;
        final List<String> resourceList = finalResourceList;
        List<String> res = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = DorisClient.this.getResources(ndl, resourceList);
                }
                catch (HadoopException he) {
                    LOG.error("<== DorisClient.getResourceList() :Unable to get the Resource List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return res;
    }

    /*
     * Loose catch block
     */
    private List<String> getResources(String needle, List<String> resourceList) {
        HashSet<String> ret = new HashSet<String>();
        if (this.con != null) {
            Statement stat = null;
            ResultSet rs = null;
            String sql = "SHOW RESOURCES";
            try {
                if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                    sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                }
                stat = this.con.createStatement();
                rs = stat.executeQuery(sql);
                while (rs.next()) {
                    String resourceName = rs.getString(1);
                    if (resourceList != null && resourceList.contains(resourceName)) continue;
                    ret.add(resourceName);
                }
                this.close(rs);
                this.close(stat);
            }
            catch (SQLTimeoutException sqlt) {
                String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                this.close(rs);
                this.close(stat);
            }
            catch (SQLException se) {
                String msg = "Unable to execute SQL [" + sql + "]. ";
                HadoopException he = new HadoopException(msg, (Throwable)se);
                he.generateResponseDataMap(false, DorisClient.getMessage((Throwable)se), msg + ERR_MSG, null, null);
                throw he;
                {
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        throw throwable;
                    }
                }
            }
        }
        return new ArrayList<String>(ret);
    }

    public List<String> getWorkloadGroupList(String needle, List<String> finalWorkloadGroupList) {
        final String ndl = needle;
        final List<String> workloadGroupList = finalWorkloadGroupList;
        List<String> res = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = DorisClient.this.getWorkloadGroup(ndl, workloadGroupList);
                }
                catch (HadoopException he) {
                    LOG.error("<== DorisClient.getWorkLoadGroupList() :Unable to get the WorkloadGroup List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return res;
    }

    /*
     * Loose catch block
     */
    private List<String> getWorkloadGroup(String needle, List<String> workloadGroupList) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con != null) {
            Statement stat = null;
            ResultSet rs = null;
            String sql = "SHOW WORKLOAD GROUPS";
            try {
                if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                    sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                }
                stat = this.con.createStatement();
                rs = stat.executeQuery(sql);
                while (rs.next()) {
                    String wgName = rs.getString(2);
                    if (workloadGroupList != null && workloadGroupList.contains(wgName)) continue;
                    ret.add(wgName);
                }
                this.close(rs);
                this.close(stat);
            }
            catch (SQLTimeoutException sqlt) {
                String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                hdpException.generateResponseDataMap(false, DorisClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                this.close(rs);
                this.close(stat);
            }
            catch (SQLException se) {
                String msg = "Unable to execute SQL [" + sql + "]. ";
                HadoopException he = new HadoopException(msg, (Throwable)se);
                he.generateResponseDataMap(false, DorisClient.getMessage((Throwable)se), msg + ERR_MSG, null, null);
                throw he;
                {
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        throw throwable;
                    }
                }
            }
        }
        return ret;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) throws Exception {
        DorisClient client = null;
        HashMap<String, Object> resp = new HashMap<String, Object>();
        boolean status = false;
        List<String> testResult = null;
        try {
            client = new DorisClient(serviceName, connectionProperties);
            if (client != null && (testResult = client.getCatalogList("*", null)) != null && testResult.size() != 0) {
                status = true;
            }
            if (status) {
                String msg = "Connection test successful";
                DorisClient.generateResponseDataMap((boolean)status, (String)msg, (String)msg, null, null, resp);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return resp;
    }

    @Override
    public void close() {
        Subject.doAs(this.getLoginSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DorisClient.this.close(DorisClient.this.con);
                return null;
            }
        });
    }

    private void close(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close Doris SQL connection", (Throwable)e);
        }
    }

    public void close(Statement stat) {
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close SQL statement", (Throwable)e);
        }
    }

    public void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close ResultSet", (Throwable)e);
        }
    }
}

