/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.doris.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.doris.client.DorisClient;
import org.apache.ranger.services.doris.client.DorisConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DorisResourceManager.class);
    private static final String CATALOG = "catalog";
    private static final String DATABASE = "database";
    private static final String TABLE = "table";
    private static final String COLUMN = "column";
    private static final String RESOURCE = "resource";
    private static final String WORKLOAD_GROUP = "workload_group";

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> DorisResourceManager.connectionTest() ServiceName: " + serviceName + " Configs: " + configs);
        }
        try {
            ret = DorisClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== DorisResourceManager.connectionTest() Error: " + e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== DorisResourceManager.connectionTest() Result : " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDorisResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block39: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            List catalogList = null;
            List schemaList = null;
            List tableList = null;
            List columnList = null;
            List resourceList = null;
            List workloadGroupList = null;
            String catalogName = null;
            String schemaName = null;
            String tableName = null;
            String columnName = null;
            String resourceName = null;
            String workloadGroupName = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== DorisResourceMgr.getDorisResources() UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap);
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    catalogList = (List)resourceMap.get(CATALOG);
                    schemaList = (List)resourceMap.get(DATABASE);
                    tableList = (List)resourceMap.get(TABLE);
                    columnList = (List)resourceMap.get(COLUMN);
                    resourceList = (List)resourceMap.get(RESOURCE);
                    workloadGroupList = (List)resourceMap.get(WORKLOAD_GROUP);
                }
                switch (resource.trim().toLowerCase()) {
                    case "catalog": {
                        catalogName = userInput;
                        break;
                    }
                    case "database": {
                        schemaName = userInput;
                    }
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column": {
                        columnName = userInput;
                        break;
                    }
                    case "resource": {
                        resourceName = userInput;
                        break;
                    }
                    case "workload_group": {
                        workloadGroupName = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> DorisResourceManager.getDorisResources() UserInput: \"" + userInput + "\" configs: " + configs + " catalogList: " + catalogList + " tableList: " + tableList + " columnList: " + columnList);
                    }
                    final DorisClient dorisClient = new DorisConnectionManager().getDorisConnection(serviceName, serviceType, configs);
                    Callable<List<String>> callableObj = null;
                    final List finalCatalogList = catalogList;
                    final List finalSchemaList = schemaList;
                    final List finalTableList = tableList;
                    final List finalColumnList = columnList;
                    final List finalResourceList = resourceList;
                    final List finalWorkloadGroupList = workloadGroupList;
                    if (dorisClient == null) break block39;
                    if (catalogName != null && !catalogName.isEmpty()) {
                        final String finalCatalogName = catalogName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return dorisClient.getCatalogList(finalCatalogName, finalCatalogList);
                            }
                        };
                    } else if (schemaName != null && !schemaName.isEmpty()) {
                        final String finalSchemaName = schemaName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return dorisClient.getSchemaList(finalSchemaName, finalCatalogList, finalSchemaList);
                            }
                        };
                    } else if (tableName != null && !tableName.isEmpty()) {
                        final String finalTableName = tableName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return dorisClient.getTableList(finalTableName, finalCatalogList, finalSchemaList, finalTableList);
                            }
                        };
                    } else if (columnName != null && !columnName.isEmpty()) {
                        final String finalColumnName = columnName = columnName + "*";
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return dorisClient.getColumnList(finalColumnName, finalCatalogList, finalSchemaList, finalTableList, finalColumnList);
                            }
                        };
                    } else if (resourceName != null && !resourceName.isEmpty()) {
                        final String finalResourceName = resourceName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return dorisClient.getResourceList(finalResourceName, finalResourceList);
                            }
                        };
                    } else if (workloadGroupName != null && !workloadGroupName.isEmpty()) {
                        final String finalWorkloadGroupName = workloadGroupName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                return dorisClient.getWorkloadGroupList(finalWorkloadGroupName, finalWorkloadGroupList);
                            }
                        };
                    } else {
                        LOG.error("Could not initiate a DorisClient timedTask");
                    }
                    if (callableObj != null) {
                        DorisClient dorisClient2 = dorisClient;
                        synchronized (dorisClient2) {
                            resultList = (List)TimedEventUtil.timedTask((Callable)callableObj, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                            break block39;
                        }
                    }
                    LOG.error("Could not initiate a DorisClient timedTask");
                }
                catch (Exception e) {
                    LOG.error("Unable to get Doris resource", (Throwable)e);
                    throw e;
                }
            }
        }
        return resultList;
    }
}

